import sys
import os

# Agregar el directorio actual al path para importar recursos
sys.path.insert(0, os.path.dirname(os.path.abspath(__file__)))

from recursos import SystemReporter

def main():
    """Ejecuta el agente directamente"""
    try:
        print("Iniciando Agente de Monitoreo...")
        
        # Crear y ejecutar el reporter directamente
        reporter = SystemReporter()
        reporter.ejecutar_loop()
        
    except KeyboardInterrupt:
        print("\nAgente detenido por el usuario")
    except SystemExit as e:
        sys.exit(e.code)
    except Exception as e:
        print(f"ERROR CRITICO en main: {e}")
        sys.exit(1)

if __name__ == "__main__":
    main()